/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.vw.api.VWValidationError;

public final class VWScenarioValidationError {
    public static final int VALIDATION_TYPE_WORKFLOW_DEF = 1;
    public static final int VALIDATION_TYPE_SCENARIO = 2;
    public static final int VALIDATION_TYPE_SCENARIO_RESOURCE = 3;
    public static final int VALIDATION_TYPE_SCENARIO_ROLE = 4;
    public static final int VALIDATION_TYPE_SCENARIO_SHIFT = 5;
    public static final int VALIDATION_TYPE_SCENARIO_WORKFLOW = 6;
    public static final int VALIDATION_TYPE_SCENARIO_ARRIVAL = 7;
    public static final int VALIDATION_TYPE_SCENARIO_STEP = 8;
    public static final int VALIDATION_LEVEL_ERROR = 1;
    public static final int VALIDATION_LEVEL_WARNING = 2;
    private int errorType = -1;
    private int level = 1;
    private String name = null;
    private String message = null;
    private String info = null;
    private int stepId = -1;
    private String mapName = null;
    private String workflowName = null;
    private VWValidationError vwValidationError;

    protected VWScenarioValidationError(int theType, int theLevel, String theName, String theInfo, String theMessage, String theWorkflowName, String theMapName, int theStepId) {
        this.errorType = theType;
        this.level = theLevel;
        this.name = theName;
        this.info = theInfo;
        this.message = theMessage;
        this.workflowName = theWorkflowName;
        this.mapName = theMapName;
        this.stepId = theStepId;
    }

    protected VWScenarioValidationError(int theType, int theLevel, String theName, String theInfo, String theMessage, String theWorkflowName) {
        this(theType, theLevel, theName, theInfo, theMessage, theWorkflowName, null, -1);
    }

    protected VWScenarioValidationError(int theType, int theLevel, String theName, String theInfo, String theMessage) {
        this(theType, theLevel, theName, theInfo, theMessage, null, null, -1);
    }

    protected VWScenarioValidationError(VWValidationError error, String theWorkflowName) {
        this(error.getErrorType(), error.getLevel(), error.getName(), error.getInfo(), error.getMessage(), theWorkflowName, error.getMapName(), error.getStepId());
        this.vwValidationError = error;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public String getName() {
        return this.name;
    }

    public String getInfo() {
        return this.info;
    }

    public String getMessage() {
        return this.message;
    }

    protected void setMessage(String theMessage) {
        this.message = theMessage;
    }

    public int getErrorType() {
        return this.errorType;
    }

    protected void setErrorType(int theErrorType) {
        this.errorType = theErrorType;
    }

    public int getLevel() {
        return this.level;
    }

    protected void setLevel(int theLevel) {
        this.level = theLevel;
    }

    public String getMapName() {
        return this.mapName;
    }

    public int getStepId() {
        return this.stepId;
    }

    protected void setStepId(int theId) {
        this.stepId = theId;
    }

    protected void setMapName(String theName) {
        this.mapName = theName;
    }

    public VWValidationError getVWValidationError() {
        return this.vwValidationError;
    }

    public String toString() {
        String outStr = "";
        switch (this.getErrorType()) {
            case 1: {
                outStr = outStr + "WORKFLOW DEFINITION:";
                break;
            }
            case 2: {
                outStr = outStr + "SCENARIO:";
                break;
            }
            case 7: {
                outStr = outStr + "SCENARIO ARRIVAL:";
                break;
            }
            case 3: {
                outStr = outStr + "SCENARIO RESOURCE:";
                break;
            }
            case 4: {
                outStr = outStr + "SCENARIO ROLE:";
                break;
            }
            case 5: {
                outStr = outStr + "SCENARIO SHIFT:";
                break;
            }
            case 8: {
                outStr = outStr + "SCENARIO STEP:";
                break;
            }
            case 6: {
                outStr = outStr + "SCENARIO WORKFLOW:";
            }
        }
        switch (this.getLevel()) {
            case 1: {
                outStr = outStr + "ERROR:";
                break;
            }
            case 2: {
                outStr = outStr + "WARNING:";
            }
        }
        if (this.getName() != null) {
            outStr = outStr + this.getName();
        }
        outStr = outStr + ":";
        if (this.getInfo() != null) {
            outStr = outStr + this.getInfo();
        }
        outStr = outStr + ":";
        if (this.getWorkflowName() != null) {
            outStr = outStr + this.getWorkflowName();
        }
        outStr = outStr + ":";
        if (this.getMapName() != null) {
            outStr = outStr + this.getMapName();
        }
        outStr = outStr + ":";
        outStr = outStr + String.valueOf(this.getStepId());
        outStr = outStr + ":";
        if (this.getMessage() != null) {
            outStr = outStr + this.getMessage();
        }
        outStr = outStr + ":";
        return outStr;
    }
}

